unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, System.ComponentModel, Borland.Vcl.StdCtrls, ShellApi;

type
  TForm1 = class(TForm)
    Button1: TButton;
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.nfm}

function OperacjaNaPliku(uchwyt :THandle;zrodlo,cel :String;operacja,opcje :Cardinal) :Boolean;
var parametryOperacji: TSHFileOpStruct;
begin
with parametryOperacji do
  begin
  Wnd:=uchwyt;
  wFunc:=operacja;
  {$IF NOT DEFINED(CLR)} //Win32
  if zrodlo<>'' then pFrom:=PChar(zrodlo+#0+#0) else pFrom:=nil;
  if cel<>'' then pTo:=PChar(cel+#0+#0) else pTo:=nil;
  {$ELSE} //.NET
  if zrodlo<>'' then pFrom:=zrodlo+#0+#0 else pFrom:=nil;
  if cel<>'' then pTo:=cel+#0+#0 else pTo:=nil;
  {$IFEND}
  fFlags:=opcje;
  hNameMappings := nil;
  lpszProgressTitle := nil;
  end;

Result:=(SHFileOperation(parametryOperacji)=0);
end;

function KopiowaniePliku(uchwyt :THandle;zrodlo,cel :String) :Boolean;
begin
Result:=OperacjaNaPliku(uchwyt,zrodlo,cel,FO_COPY,0);
end;

function PrzenoszeniePliku(uchwyt :THandle;zrodlo,cel :String) :Boolean;
begin
Result:=OperacjaNaPliku(uchwyt,zrodlo,cel,FO_MOVE,0);
end;

function UsuwaniePliku(uchwyt :THandle;zrodlo :String) :Boolean;
begin
Result:=OperacjaNaPliku(uchwyt,zrodlo,'',FO_DELETE,0);
end;

function UsuwaniePlikuDoKosza(uchwyt :THandle;zrodlo :String) :Boolean;
begin
Result:=OperacjaNaPliku(uchwyt,ExpandFileName(zrodlo),'',FO_DELETE,FOF_ALLOWUNDO);
end;

function KopiowanieKatalogu(uchwyt :THandle;zrodlo,cel :String) :Boolean;
begin
Result:=OperacjaNaPliku(uchwyt,zrodlo+'\*.*',cel,FO_COPY,FOF_NOCONFIRMMKDIR);
end;

function PrzenoszenieKatalogu(uchwyt :THandle;zrodlo,cel :String) :Boolean;
begin
Result:=OperacjaNaPliku(uchwyt,zrodlo+'\*.*',cel,FO_MOVE,FOF_NOCONFIRMMKDIR);
RmDir(zrodlo);
end;

function UsuwanieKatalogu(uchwyt :THandle;zrodlo :String) :Boolean;
begin
Result:=UsuwaniePliku(uchwyt,zrodlo);
end;

function UsuwanieKataloguDoKosza(uchwyt :THandle;zrodlo :String) :Boolean;
begin
Result:=UsuwaniePlikuDoKosza(uchwyt,zrodlo);
end;


procedure TForm1.Button1Click(Sender: TObject);
begin
KopiowaniePliku(Handle,'Project1.bdsproj','d:\Kopia pliku Project1.bdsproj.txt');
PrzenoszeniePliku(Handle,'d:\Kopia pliku Project1.bdsproj.txt','d:\Kopia pliku.xml');
//UsuwaniePliku(Handle,'d:\Kopia pliku.xml');
UsuwaniePlikuDoKosza(Handle,'d:\Kopia pliku.xml');

KopiowanieKatalogu(Handle,'.','d:\Kopia projektu');
PrzenoszenieKatalogu(Handle,'d:\Kopia projektu','d:\Przeniesiona kopia');
UsuwanieKataloguDoKosza(Handle,'d:\Przeniesiona kopia');
end;

end.
